// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Svrhttpindy.pas' rev: 10.00

#ifndef SvrhttpindyHPP
#define SvrhttpindyHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Syncobjs.hpp>	// Pascal unit
#include <Webbroker.hpp>	// Pascal unit
#include <Httpapp.hpp>	// Pascal unit
#include <Svrlog.hpp>	// Pascal unit
#include <Idhttpserver.hpp>	// Pascal unit
#include <Idcustomhttpserver.hpp>	// Pascal unit
#include <Idtcpserver.hpp>	// Pascal unit
#include <Idintercept.hpp>	// Pascal unit
#include <Idsockethandle.hpp>	// Pascal unit
#include <Inifiles.hpp>	// Pascal unit
#include <Sockappnotify.hpp>	// Pascal unit
#include <Idstackconsts.hpp>	// Pascal unit
#include <Idglobal.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Svrhttpindy
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EWebServerException;
class DELPHICLASS TWebServerRequest;
class PASCALIMPLEMENTATION TWebServerRequest : public Httpapp::TWebRequest 
{
	typedef Httpapp::TWebRequest inherited;
	
private:
	Classes::TThread* FThread;
	Idcustomhttpserver::TIdHTTPRequestInfo* FIdHTTPRequestInfo;
	Idcustomhttpserver::TIdHTTPResponseInfo* FIdHTTPResponseInfo;
	int FReadClientIndex;
	void __fastcall SetStringVariable(int Index, const AnsiString Value);
	void __fastcall SetIntegerVariable(int Index, int Value);
	void __fastcall SetDateVariable(int Index, System::TDateTime Value);
	
protected:
	virtual AnsiString __fastcall GetStringVariable(int Index);
	virtual System::TDateTime __fastcall GetDateVariable(int Index);
	virtual int __fastcall GetIntegerVariable(int Index);
	
public:
	__fastcall TWebServerRequest(int APort, AnsiString ARemoteAddress, AnsiString ARemoteHost, Idcustomhttpserver::TIdHTTPRequestInfo* ARequestInfo, Idcustomhttpserver::TIdHTTPResponseInfo* AResponseInfo, Classes::TThread* AThread);
	virtual AnsiString __fastcall GetFieldByName(const AnsiString Name);
	virtual int __fastcall ReadClient(void *Buffer, int Count);
	virtual AnsiString __fastcall ReadString(int Count);
	virtual AnsiString __fastcall TranslateURI(const AnsiString URI);
	virtual int __fastcall WriteClient(void *Buffer, int Count);
	virtual bool __fastcall WriteString(const AnsiString AString);
	virtual bool __fastcall WriteHeaders(int StatusCode, const AnsiString StatusString, const AnsiString Headers);
	__property Idcustomhttpserver::TIdHTTPRequestInfo* RequestInfo = {read=FIdHTTPRequestInfo};
	__property Classes::TThread* Thread = {read=FThread};
public:
	#pragma option push -w-inl
	/* TWebRequest.Destroy */ inline __fastcall virtual ~TWebServerRequest(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION EWebServerException : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
private:
	TWebServerRequest* FRequest;
	
public:
	__fastcall EWebServerException(const AnsiString Message, TWebServerRequest* ARequest);
	__property TWebServerRequest* Request = {read=FRequest};
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EWebServerException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EWebServerException(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EWebServerException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EWebServerException(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EWebServerException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EWebServerException(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EWebServerException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EWebServerException(void) { }
	#pragma option pop
	
};


class DELPHICLASS EFailedToRetreiveTimeZoneInfo;
class PASCALIMPLEMENTATION EFailedToRetreiveTimeZoneInfo : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EFailedToRetreiveTimeZoneInfo(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EFailedToRetreiveTimeZoneInfo(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EFailedToRetreiveTimeZoneInfo(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EFailedToRetreiveTimeZoneInfo(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EFailedToRetreiveTimeZoneInfo(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EFailedToRetreiveTimeZoneInfo(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EFailedToRetreiveTimeZoneInfo(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EFailedToRetreiveTimeZoneInfo(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EFailedToRetreiveTimeZoneInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TConnectionIntercept;
class PASCALIMPLEMENTATION TConnectionIntercept : public Idintercept::TIdConnectionIntercept 
{
	typedef Idintercept::TIdConnectionIntercept inherited;
	
public:
	__fastcall virtual TConnectionIntercept(Classes::TComponent* AOwner);
	__fastcall virtual ~TConnectionIntercept(void);
	virtual void __fastcall Receive(Classes::TStream* ABuffer);
	virtual void __fastcall Send(Classes::TStream* ABuffer);
};


class DELPHICLASS TServerIntercept;
class PASCALIMPLEMENTATION TServerIntercept : public Idintercept::TIdServerIntercept 
{
	typedef Idintercept::TIdServerIntercept inherited;
	
public:
	virtual void __fastcall Init(void);
	virtual Idintercept::TIdConnectionIntercept* __fastcall Accept(Classes::TComponent* AConnection);
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TServerIntercept(Classes::TComponent* AOwner) : Idintercept::TIdServerIntercept(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TServerIntercept(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRequestLogBuffer;
class PASCALIMPLEMENTATION TRequestLogBuffer : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FLogBuffer;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRequestLogBuffer(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRequestLogBuffer(void) { }
	#pragma option pop
	
};


class DELPHICLASS TWebServerResponse;
class DELPHICLASS TServerLog;
class DELPHICLASS TCustomWebServer;
class PASCALIMPLEMENTATION TCustomWebServer : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Idglobal::TIdMimeTable* FMimeTable;
	Idhttpserver::TIdHTTPServer* FHTTPServer;
	TServerLog* FLog;
	Svrlog::THTTPLogEvent FOnLog;
	AnsiString FSearchPath;
	AnsiString FDefaultURL;
	AnsiString FExpandedSearchPath;
	Sockappnotify::TRunningWebAppListener* FRunningWebAppListener;
	AnsiString __fastcall GetTranslatedDefaultURL();
	AnsiString __fastcall GetExpandedSearchPath();
	void __fastcall SetSearchPath(const AnsiString Value);
	void __fastcall HTTPServerCommandGet(Idtcpserver::TIdPeerThread* AThread, Idcustomhttpserver::TIdHTTPRequestInfo* RequestInfo, Idcustomhttpserver::TIdHTTPResponseInfo* ResponseInfo);
	void __fastcall HTTPServerCommandOther(Idtcpserver::TIdPeerThread* Thread, const AnsiString asCommand, const AnsiString asData, const AnsiString asVersion);
	void __fastcall ExecuteHTTPRequest(Classes::TThread* Thread, Idcustomhttpserver::TIdHTTPRequestInfo* RequestInfo, Idcustomhttpserver::TIdHTTPResponseInfo* ResponseInfo);
	bool __fastcall DoFileAccess(TWebServerRequest* Request, bool IsHeadMethod, Idcustomhttpserver::TIdHTTPResponseInfo* ResponseInfo);
	AnsiString __fastcall GetMIMEType(const AnsiString FileName);
	void __fastcall URLNotFound(TWebServerRequest* Request, Idcustomhttpserver::TIdHTTPResponseInfo* ResponseInfo);
	void __fastcall HandleException(TWebServerRequest* Request, Idcustomhttpserver::TIdHTTPResponseInfo* ResponseInfo);
	void __fastcall ServerError(TWebServerRequest* Request, Idcustomhttpserver::TIdHTTPResponseInfo* ResponseInfo, const AnsiString ErrorMsg);
	void __fastcall LogRequest(TWebServerRequest* Request);
	__property AnsiString ExpandedSearchPath = {read=GetExpandedSearchPath};
	int __fastcall GetPort(void);
	void __fastcall SetPort(const int Value);
	bool __fastcall GetActive(void);
	void __fastcall SetActive(const bool Value);
	
public:
	__property AnsiString TranslatedDefaultURL = {read=GetTranslatedDefaultURL};
	__property bool Active = {read=GetActive, write=SetActive, nodefault};
	__property AnsiString SearchPath = {read=FSearchPath, write=SetSearchPath};
	__property AnsiString DefaultURL = {read=FDefaultURL, write=FDefaultURL};
	__property int Port = {read=GetPort, write=SetPort, nodefault};
	__property Svrlog::THTTPLogEvent OnLog = {read=FOnLog, write=FOnLog};
	__property Sockappnotify::TRunningWebAppListener* RunningWebAppListener = {read=FRunningWebAppListener};
	__fastcall virtual TCustomWebServer(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomWebServer(void);
};


class PASCALIMPLEMENTATION TServerLog : public Svrlog::TCustomServerLog 
{
	typedef Svrlog::TCustomServerLog inherited;
	
private:
	TCustomWebServer* FWebServer;
	
protected:
	virtual void __fastcall DoOnLog(Svrlog::TTransactionLogEntry* Transaction, bool &Release);
	
public:
	__fastcall TServerLog(TCustomWebServer* AServer);
public:
	#pragma option push -w-inl
	/* TCustomServerLog.Destroy */ inline __fastcall virtual ~TServerLog(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TWebServerResponse : public Httpapp::TWebResponse 
{
	typedef Httpapp::TWebResponse inherited;
	
private:
	Idcustomhttpserver::TIdHTTPResponseInfo* FIdHTTPResponseInfo;
	TWebServerRequest* FRequest;
	TServerLog* FLog;
	AnsiString FLogBuffer;
	bool FSent;
	
protected:
	virtual void __fastcall SetStatusCode(int Value);
	virtual void __fastcall SetContent(const AnsiString Value);
	virtual void __fastcall SetContentStream(Classes::TStream* Value);
	virtual AnsiString __fastcall GetStringVariable(int Index);
	virtual void __fastcall SetStringVariable(int Index, const AnsiString Value);
	virtual System::TDateTime __fastcall GetDateVariable(int Index);
	virtual void __fastcall SetDateVariable(int Index, const System::TDateTime Value);
	virtual int __fastcall GetIntegerVariable(int Index);
	virtual void __fastcall SetIntegerVariable(int Index, int Value);
	virtual AnsiString __fastcall GetContent();
	virtual int __fastcall GetStatusCode(void);
	virtual AnsiString __fastcall GetLogMessage();
	virtual void __fastcall SetLogMessage(const AnsiString Value);
	
public:
	virtual void __fastcall SendResponse(void);
	virtual void __fastcall SendRedirect(const AnsiString URI);
	virtual void __fastcall SendStream(Classes::TStream* AStream);
	virtual bool __fastcall Sent(void);
	__property TWebServerRequest* Request = {read=FRequest};
	__fastcall TWebServerResponse(TWebServerRequest* ARequest, Idcustomhttpserver::TIdHTTPResponseInfo* AResponseInfo, TServerLog* ALog);
	__fastcall virtual ~TWebServerResponse(void);
};


typedef DynamicArray<int >  TSocketArray;

#pragma option push -b-
enum TErrorCode { ecTimeout, ecExecFail, ecTokenMismatch, ecOK };
#pragma option pop

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Svrhttpindy */
using namespace Svrhttpindy;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Svrhttpindy
